/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.impl;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import java.util.ArrayList;
import java.util.List;

public class MapKeyWriter
extends SerializeWriter<MalformedDataException, MapKeyWriter> {
    private String result = null;
    private List<String> comments = new ArrayList<String>();
    private boolean isFailureOrigin = false;

    public String getResult() {
        return this.result;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public boolean isFailureOrigin() {
        return this.isFailureOrigin;
    }

    @Override
    public MapKeyWriter beginArray() throws MalformedDataException {
        this.isFailureOrigin = true;
        throw new MalformedDataException("Cannot write arrays in map keys");
    }

    @Override
    public MapKeyWriter endArray() throws MalformedDataException {
        this.isFailureOrigin = true;
        throw new MalformedDataException("Cannot end arrays in map keys");
    }

    @Override
    public MapKeyWriter beginObject() throws MalformedDataException {
        this.isFailureOrigin = true;
        throw new MalformedDataException("Cannot write objects in map keys");
    }

    @Override
    public MapKeyWriter endObject() throws MalformedDataException {
        this.isFailureOrigin = true;
        throw new MalformedDataException("Cannot end objects in map keys");
    }

    @Override
    public MapKeyWriter comment(String comment) throws MalformedDataException {
        this.comments.add(comment);
        return this;
    }

    @Override
    public MapKeyWriter name(String name) throws MalformedDataException {
        if (this.result != null) {
            this.isFailureOrigin = true;
            throw new MalformedDataException("Cannot write multiple names in map keys");
        }
        this.result = name;
        return this;
    }

    @Override
    public MapKeyWriter value(String value) throws MalformedDataException {
        if (this.result != null) {
            this.isFailureOrigin = true;
            throw new MalformedDataException("Cannot write multiple values in map keys");
        }
        this.result = value;
        return this;
    }

    @Override
    public MapKeyWriter literalValue(String value) throws MalformedDataException {
        if (this.result != null) {
            this.isFailureOrigin = true;
            throw new MalformedDataException("Cannot write multiple values in map keys");
        }
        this.result = value;
        return this;
    }

    @Override
    protected MalformedDataException createException(String message) {
        return new MalformedDataException(message + " in map key");
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

